# Quantum Route Redirect

Advanced visitor classification and intelligent redirection system with anti-crawling protection and real-time analytics.

## Features

- **Anti-Crawling Protection**: Prevents social media bots from discovering final destination URLs
- **Real-time Visitor Analytics**: Live tracking with 5-second refresh intervals
- **Custom Shortcode Support**: Create branded redirect URLs with custom identifiers
- **Dual Classification**: Local pre-screening + external API validation
- **Tabbed Dashboard**: Organized visitor lists (All/Human/Bot)
- **Secure Admin Panel**: Password-protected management interface

## Quick Start

1. Access admin panel at your domain root
2. Login with password: `admin123` (change immediately)
3. Configure destination URLs for humans and bots
4. Copy generated redirect link from admin panel
5. Share your link - visitor data appears automatically

## Files

- `index.html` - Admin panel interface
- `quantum.php` - Visitor classification engine
- `admin_auth.php` - Authentication handler
- `get_config.php` - Configuration API
- `update_config.php` - Configuration update handler
- Configuration files: `api_key.txt`, `redirect_url.txt`, `bot_url.txt`
- Security files: `.htaccess`, `robots.txt`

## Security

- Password-protected admin access
- Session-based authentication
- Anti-crawling meta tags and headers
- Immediate bot redirection prevents URL discovery
- Input validation and sanitization

Your system is production-ready with secure default settings.