# Quantum Route Redirect

This is **Quantum Route Redirect** - an advanced PHP-based visitor classification and intelligent redirection system with **ANTI-CRAWLING PROTECTION** and **BUILT-IN REDIRECT GENERATOR**. The system automatically classifies website visitors as "bot" or "human" using both local detection and an external API service. **CRITICAL SECURITY FEATURE: Prevents social media bots (Telegram, WhatsApp, Facebook, etc.) from discovering the final destination URLs through preview crawling.**

## PRODUCTION ARCHITECTURE (Updated Aug 6, 2025)
- **Admin Panel at Root (/)**: Complete management interface accessible at domain root
- **Redirect Generator (/quantum.php)**: Shareable link that performs the actual visitor classification and redirection
- **Custom Shortcode Support**: Optional shortcode generation for branded/memorable redirect URLs
- **Tabbed Analytics**: Organized visitor lists with All/Human/Bot separation with empty state for fresh launches
- **Enhanced Auto-refresh**: 5-second polling for near real-time updates
- **First Launch Ready**: Clean state with no visitor data and default configuration

# User Preferences

Preferred communication style: Simple, everyday language.

# System Architecture

## Frontend Architecture
- **Enhanced HTML Admin Panel**: A comprehensive admin interface (`admin.html`) with visitor logs and system configuration
- **Modern CSS Styling**: Responsive design with blue color scheme, hover effects, and mobile-friendly layout
- **Interactive JavaScript**: Dynamic configuration management, real-time API testing, and auto-refresh functionality

## Backend Architecture
- **PHP-based Classification Engine**: Main entry point (`index.php`) handles visitor detection, classification, and redirection
- **Dual Classification Strategy**: 
  - Local pre-screening using User-Agent analysis
  - External API validation via Quantum Route API
- **File-based Configuration**: Uses `redirect_url.txt` for dynamic URL configuration

## Data Flow
1. **Visitor Request**: User lands on `index.php`
2. **Data Extraction**: System captures IP address and User-Agent string
3. **Local Pre-screening**: Browser and device type detection from User-Agent
4. **API Classification**: External validation for likely human visitors
5. **Redirection Decision**: Route to appropriate URL based on classification
6. **Logging**: Human visitors logged to `admin.html` file

# Key Components

## Visitor Detection Module
- **ANTI-CRAWLING PROTECTION**: Immediate blocking of social media crawlers (Telegram, Facebook, Twitter, WhatsApp, LinkedIn, Slack, Discord) before destination discovery
- **IP Address Extraction**: Multi-header fallback system for accurate IP detection  
- **User-Agent Analysis**: Local parsing for browser type (Chrome, Firefox, Safari, Edge, IE) and device type (Desktop/Mobile)
- **Bot Pre-screening**: Immediate bot classification for "Unknown" browser/device combinations
- **HTTP Security Headers**: Prevents indexing, caching, and preview generation

## External API Integration
- **Quantum Route API**: Third-party classification service
- **Endpoint**: `https://quantumroutes.replit.app/api/classify`
- **Authentication**: API key-based authentication via `X-API-Key` header
- **Request Masking**: Browser-like headers to appear as legitimate traffic

## Admin Panel Features
- **Password Protection**: Secure login system with changeable admin password (default: admin123)
- **Session Management**: PHP session-based authentication with login/logout functionality
- **Visitor Logging**: HTML-based storage with ALL visitor data (both humans and bots) appended directly to `admin.html`
- **Custom Shortcode Generator**: Create branded URLs with custom shortcodes (e.g., /quantum.php?c=my-promo)
- **Enhanced Statistics Dashboard**: 
  - Total visitor count
  - Today's visitor count  
  - Separate counts for Human vs Bot visitors
  - Real-time visitor classification statistics
  - Shortcode tracking in visitor location data
- **Configuration Management**: Dynamic URL and API key configuration through web interface
- **API Status Monitoring**: Manual API connection testing (no automatic quota waste)
- **Password Management**: Ability to change admin password after login
- **Smart Auto-refresh**: Automatic data refresh every 5 seconds for near real-time monitoring

## Configuration Management
- **Dynamic URL Configuration**: `redirect_url.txt` and `bot_url.txt` files for redirect URLs
- **User-managed API Keys**: Users must obtain and configure their own API keys via admin panel
- **Web-based Configuration**: Admin panel interface for real-time configuration updates
- **Secure Storage**: API keys stored in `api_key.txt` file for persistence
- **Fallback System**: Hardcoded defaults ensure system reliability when API unavailable

# Data Flow

```
Visitor Request → IP/User-Agent Extraction → Local Bot Detection → 
API Classification (if needed) → Redirection Decision → 
Logging (ALL visitors: humans AND bots) → URL Redirect
```

# External Dependencies

## Third-party Services
- **Quantum Route API**: External classification service requiring API key authentication
- **Microsoft Online Services**: Default redirect destination for human visitors

## PHP Requirements
- **cURL Extension**: Required for external API communication
- **File System Access**: Needed for reading configuration and writing logs

# Deployment Strategy

## File Structure
- **Admin Panel**: `index.html` serves as the admin interface at domain root
- **Redirect Engine**: `quantum.php` serves as the main visitor classification entry point
- **Static Assets**: HTML admin panel and configuration files
- **No Database Required**: File-based storage eliminates database dependencies

## Configuration Requirements
- **API Key**: Must be configured in PHP script for Quantum Route API access
- **File Permissions**: Write access required for `admin.html` logging
- **Web Server**: Standard PHP-enabled web server (Apache, Nginx, etc.)

## Security Considerations
- **API Key Protection**: Sensitive credentials embedded in source code
- **Input Validation**: User-Agent and IP address handling
- **File-based Logging**: Direct HTML file manipulation for visitor data

The system prioritizes simplicity and effectiveness, using a hybrid approach of local detection and external API validation to accurately classify visitors while maintaining fast response times through pre-screening mechanisms.